{
 Author:       Craig Ward
 Copyright:    <>

 Date:         17/5/96

 Version:      1.0

 Overview:     Configuration dialog.

 Notes:        The procs that deal with the reading and writing to the
               control.ini file is stored in the conini.pas unit.
*******************************************************************************}
unit Config;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, messages, dialogs, Cwbutton, Spin,
  IniFiles, sysutils;

type
  TScreenSaveDialog = class(TForm)
    cwButton1: TcwButton;
    cwButton2: TcwButton;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    cwButton4: TcwButton;
    Label1: TLabel;
    spinSec: TSpinEdit;
    GroupBox2: TGroupBox;
    cwButton5: TcwButton;
    cwButton6: TcwButton;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    cwButton7: TcwButton;
    procedure cwButton2Click(Sender: TObject);
    procedure cwButton1Click(Sender: TObject);
    procedure cwButton4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure cwButton5Click(Sender: TObject);
    procedure cwButton6Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure cwButton7Click(Sender: TObject);
  private
    { Private declarations }
    FWindowsDir: string;
    procedure CollList;
  public
    { Public declarations }
    FPassword: string;
    FCollections: TStringList;
  end;

var
  ScreenSaveDialog: TScreenSaveDialog;


implementation

{$R *.DFM}

uses
 passw, conini, remcoll, addcoll, setcoll;

{***buttons*********************************************************************}

{close}
procedure TScreenSaveDialog.cwButton2Click(Sender: TObject);
begin
 close;
end;

{ok}
procedure TScreenSaveDialog.cwButton1Click(Sender: TObject);
begin
 {write settings to ini}
 wChangePic := spinSec.value;
 bPasswordOn := checkBox1.checked;
 bScrollTextOn := checkBox2.checked;
 bWallPaperOn := checkbox3.checked;
 bUseAll := checkBox4.checked;
 sPasswordText := FPassword;
 mWriteToIni;
 close;
end;


{***password********************************************************************}

{password dialog}
procedure TScreenSaveDialog.cwButton4Click(Sender: TObject);
begin
 screen.cursor := crHourGlass;
 PassDlg := TPassDlg.create(application);
 try
  screen.cursor := crDefault;
  if PassDlg.showModal = mrOK then
   begin
    FPassword := mEncrypt(PassDlg.Edit2.text);
   end;
 finally
  PassDlg.free;
  screen.cursor := crDefault;
 end;
end;



{***form's preferences*********************************************************}

{on create}
procedure TScreenSaveDialog.FormCreate(Sender: TObject);
begin

 {settings}
 mReadIni;
 FPassword := sPasswordText;
 checkbox1.checked := bPasswordOn; checkBox1Click(self);
 checkBox2.checked := bScrollTextOn;
 checkbox3.checked := bwallPaperOn;
 checkbox4.checked := bUseAll; checkBox4Click(self);
 spinSec.value := wChangePic;

 {collections}
 FCollections := TStringList.create;
 CollList;

end;

{on click}
procedure TScreenSaveDialog.CheckBox1Click(Sender: TObject);
begin
 cwButton4.enabled := checkBox1.checked;
end;

{on click}
procedure TScreenSaveDialog.CheckBox4Click(Sender: TObject);
begin
 if not checkBox4.checked then
  cwButton7.enabled := true
 else
  cwButton7.enabled := false;
end;

{set collection}
procedure TScreenSaveDialog.cwButton7Click(Sender: TObject);
var
 i: integer;
begin
 screen.cursor := crHourGlass;
 SetCollectDlg := TSetCollectDlg.create(application);
 try
  screen.cursor := crDefault;
  {populate combo box with collections}
  with SetCollectDlg.comboBox1 do
   begin
    clear;
    for i := 0 to (FCollections.count -1) do
     items.add( copy( FCollections.strings[i],pos('=',FCollections.strings[i])+1,gintMaxCollName));
    if sCollection <> '' then itemIndex := items.IndexOf(sCollection);
   end;
  if SetCollectDlg.showModal = mrOK then sCollection := SetCollectDlg.comboBox1.text;
 finally
  screen.cursor := crDefault;
  SetCollectDlg.free;
 end;
end;


{add}
procedure TScreenSaveDialog.cwButton5Click(Sender: TObject);
begin
 screen.cursor := crHourGlass;
 AddCollectDlg := TAddCollectDlg.create(application);
 try
  screen.cursor := crDefault;
  {on ok, update collection list}
  if AddCollectDlg.showModal = mrOK then CollList;
 finally
  screen.cursor := crDefault;
  AddCollectDlg.free;
 end;
end;

{remove}
procedure TScreenSaveDialog.cwButton6Click(Sender: TObject);
begin
 screen.cursor := crHourGlass;
 RemCollectDlg := TRemCollectDlg.create(application);
 try
  screen.cursor := crDefault;
  {on ok, update collection list}
  if RemCollectDlg.showModal = mrOK then CollList;
 finally
  screen.cursor := crDefault;
  RemCollectDlg.free;
 end;
end;


{***ini************************************************************************}

{store collections}
procedure TScreenSaveDialog.CollList;
var
 inf: TIniFile;
begin
 inf := TIniFile.create(ExtractFilePath(paramStr(0))+'delphiss.ini');
 try
  FCollections.clear;
  inf.ReadSectionValues('COLLECTIONS',FCollections);
 finally
  inf.free;
 end;
end;




end.
